import java.applet.Applet;

import java.awt.Label;
import java.awt.TextField;
import java.awt.Button;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Color;
import java.awt.Event;


import java.net.URL;
import java.net.MalformedURLException;

import java.util.Vector;
import java.util.Enumeration;
import java.util.Hashtable;

import COM.Extropia.net.JavaCGIBridge;
import COM.Extropia.net.JavaCGIBridgeTimeOutException;

public class ExampleApplet1 extends Applet {
    private Label messageLabel = 
         new Label("Enter string to reverse via CGI:");
    private TextField originalTextField = 
         new TextField("hello");
    private Button cgiButton = 
         new Button("Calculate & Display Using CGI/Perl Results");
    private Label reverseLabel = new Label("");
    private Label messageReverseLabel = 
         new Label("Reversed String:");

    private String cgiURL = null;

    public void init() {

        this.setBackground(Color.white);
        setLayout(new BorderLayout());

        Panel p = new Panel();
        p.setLayout(new BorderLayout());
        messageLabel.setBackground(Color.white);
        reverseLabel.setBackground(Color.white);
        messageReverseLabel.setBackground(Color.white);
        p.add("North", messageLabel);
        p.add("South", originalTextField);
        add("North", p);

        add("South", cgiButton);

        Panel pCenter = new Panel();
        pCenter.setLayout(new GridLayout(1,2));
        pCenter.add(messageReverseLabel);
        pCenter.add(reverseLabel);
        add("Center", pCenter);

        getSetupFile();        
    } // end of init method

    public boolean handleEvent(Event e) {
        if (e.id == Event.ACTION_EVENT && e.target == cgiButton) {
            clicked_cgiButton();
        }
        return super.handleEvent(e);
    }

    private void clicked_cgiButton() {
        JavaCGIBridge jcb = new JavaCGIBridge();
        Vector returnedDataSet = null;
        URL u = null;

        try {
            if (cgiURL.startsWith("http")) {
                 u = new URL(cgiURL); 
            } else {
                 u = new URL(getCodeBase(), cgiURL);
            }
            Hashtable formVars = new Hashtable();
            
            jcb.addFormValue(formVars,"javacgibridge", "on");
            jcb.addFormValue(formVars,
                "originalstring",originalTextField.getText());

            returnedDataSet = jcb.getParsedData(u,formVars);

        } catch (MalformedURLException e) {
            System.out.println("Malformed URL Exception:" + e);
        } catch (JavaCGIBridgeTimeOutException e) {
            System.out.println("JavaCGIBridge Timed Out:" + e);
        }

        String s = 
          (String)((Vector)returnedDataSet.elementAt(0)).elementAt(0);
        reverseLabel.setText(s);
    }


    private void getSetupFile() {
        JavaCGIBridge jcb = new JavaCGIBridge();
        // Since we are reading a setup file, we just want
        // to make it into a variable=value format instead of the
        // funky ~|~ seperator that is the default. This makes the
        // setup file easier to read at the risk of making sure a 
        // particular variable does not have an equal symbol in its
        // value.
        jcb.setFieldSeparator("=");
        jcb.setRowSeparator("\n");

        Vector returnedDataSet = null;
        Hashtable keyValuePairs = null;

        try {
            URL u = new URL(getCodeBase(), "../example1_setup.html");
 
            returnedDataSet = jcb.getParsedData(u);

            // We call the function below since the vectors that 
            // are returned contain setup information in the form of
            // the first field being a key (variable) and the second
            // field being a value to the key

            keyValuePairs = jcb.getKeyValuePairs(returnedDataSet);

        } catch (MalformedURLException e) {
            System.out.println("Malformed URL Exception:" + e);
        } catch (JavaCGIBridgeTimeOutException e) {
            System.out.println("JavaCGIBridge Timed Out:" + e);
        }
 
        cgiURL = (String)keyValuePairs.get("cgiURL");

    } // end of getSetupFile

} // end of ExampleApplet
