import java.applet.Applet;

import java.awt.Label;
import java.awt.TextField;
import java.awt.Button;
import java.awt.BorderLayout;
import java.awt.Panel;
import java.awt.Color;
import java.awt.Event;

import java.net.URL;
import java.net.MalformedURLException;

import java.util.Vector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

import COM.Extropia.net.JavaCGIBridge;
import COM.Extropia.net.JavaCGIBridgeTimeOutException;

public class ExampleApplet2 extends Applet {
    private Vector aListOfNumbers = null;
    private BarChart bc = null;
    private Label messageLabel = 
         new Label("Enter #s For Raising To The Power Of 2 via CGI:");
    private TextField numbersTextField = 
         new TextField("10 20 30");
    private Button cgiButton = 
         new Button("Calculate & Graph Using CGI/Perl Results");
    private Button graphButton = 
         new Button("Graph Numbers As-Is");

    private String cgiURL = null;

    public void init() {
        bc = new BarChart(new Vector());
        repaintBars();
        

        setLayout(new BorderLayout());

        add("Center", bc);
        Panel p = new Panel();
        p.setLayout(new BorderLayout());
        messageLabel.setBackground(Color.white);
        p.add("North", messageLabel);
        p.add("South", numbersTextField);
        add("North", p);
        
        Panel pSouth = new Panel();
        pSouth.setLayout(new BorderLayout());
        pSouth.add("North", graphButton);
        pSouth.add("South", cgiButton);
        add("South", pSouth);

        getSetupFile();        
    } // end of init method

    public boolean handleEvent(Event e) {
        if (e.id == Event.ACTION_EVENT && e.target == graphButton) {
            clicked_graphButton();
        }
        if (e.id == Event.ACTION_EVENT && e.target == cgiButton) {
            clicked_cgiButton();
        }
        return super.handleEvent(e);
    }

    private void clicked_cgiButton() {
        JavaCGIBridge jcb = new JavaCGIBridge();
        Vector returnedDataSet = null;
        URL u = null;

        try {
            if (cgiURL.startsWith("http")) {
                 u = new URL(cgiURL); 
            } else {
                 u = new URL(getCodeBase(), cgiURL);
            }
            Hashtable formVars = new Hashtable();
            
            jcb.addFormValue(formVars,"javacgibridge", "on");
            jcb.addFormValue(formVars,
                "valuelist",numbersTextField.getText());

            returnedDataSet = jcb.getParsedData(u,formVars);

        } catch (MalformedURLException e) {
            System.out.println("Malformed URL Exception:" + e);
        } catch (JavaCGIBridgeTimeOutException e) {
            System.out.println("JavaCGIBridge Timed Out:" + e);
        }

        aListOfNumbers = new Vector();
        for (Enumeration e = returnedDataSet.elements();
             e.hasMoreElements();) {
            Vector v = (Vector)e.nextElement();
            Float f = new Float((String)v.elementAt(0));
            aListOfNumbers.addElement(f);
        }
        bc.setDataSet(aListOfNumbers);
    }

    private void clicked_graphButton() {
        repaintBars();
    }

    private void repaintBars() {
        StringTokenizer t = new
          StringTokenizer(numbersTextField.getText());

        aListOfNumbers = new Vector();

        for (;t.hasMoreElements();) {
            aListOfNumbers.addElement(new Float(t.nextToken()));
        }
        bc.setDataSet(aListOfNumbers);

    } // end of repaintBars

    private void getSetupFile() {
        JavaCGIBridge jcb = new JavaCGIBridge();

        // Since we are reading a setup file, we just want
        // to make it into a variable=value format instead of the
        // funky ~|~ seperator that is the default. This makes the
        // setup file easier to read at the risk of making sure a
        // particular variable does not have an equal symbol in its
        // value.
        jcb.setFieldSeparator("=");
        jcb.setRowSeparator("\n");

        Vector returnedDataSet = null;
        Hashtable keyValuePairs = null;

        try {
            URL u = new URL(getCodeBase(), "../example2_setup.html");
 
            returnedDataSet = jcb.getParsedData(u);

            // We call the function below since the vectors that 
            // are returned contain setup information in the form of
            // the first field being a key (variable) and the second
            // field being a value to the key

            keyValuePairs = jcb.getKeyValuePairs(returnedDataSet);

        } catch (MalformedURLException e) {
            System.out.println("Malformed URL Exception:" + e);
        } catch (JavaCGIBridgeTimeOutException e) {
            System.out.println("JavaCGIBridge Timed Out:" + e);
        }
 
        cgiURL = (String)keyValuePairs.get("cgiURL");

    } // end of getSetupFile

} // end of ExampleApplet
